{{-- resources/views/filament/license-inspect-modal.blade.php --}}
{{-- Manuel Sorgula modal içeriği --}}

<div class="space-y-4 text-sm">

    {{-- Lisans Özeti --}}
    <div class="rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="bg-gray-50 dark:bg-gray-800 px-4 py-2 font-semibold text-gray-700 dark:text-gray-200">
            Lisans Özeti
        </div>
        <div class="divide-y divide-gray-100 dark:divide-gray-700">
            @php
                $rows = [
                    ['Lisans Anahtarı',    $license->license_key],
                    ['Müşteri',            $license->customer_name . ' — ' . $license->customer_email],
                    ['Kayıtlı Domain',     $license->domain ?: '—'],
                    ['Aktivasyonlar',      $license->current_activations . ' / ' . $license->activation_limit],
                    ['Durum',              match($license->status) {
                                               'active'    => '✅ Aktif',
                                               'suspended' => '🚫 Askıya Alındı',
                                               'expired'   => '⏰ Süresi Doldu',
                                               default     => $license->status,
                                           }],
                    ['Bitiş Tarihi',       $license->valid_until
                                               ? $license->valid_until->timezone('Europe/Istanbul')->format('d.m.Y H:i')
                                               : 'Sınırsız'],
                    ['Son Doğrulama',      $license->last_verify_at
                                               ? $license->last_verify_at->timezone('Europe/Istanbul')->format('d.m.Y H:i:s') . ' (' . $license->last_verify_at->diffForHumans() . ')'
                                               : 'Henüz doğrulanmadı'],
                    ['Oluşturulma',        $license->created_at->timezone('Europe/Istanbul')->format('d.m.Y H:i')],
                ];
            @endphp

            @foreach ($rows as [$label, $value])
                <div class="flex px-4 py-2 gap-4">
                    <span class="w-40 shrink-0 text-gray-500 dark:text-gray-400">{{ $label }}</span>
                    <span class="font-medium text-gray-800 dark:text-gray-100 font-mono text-xs">{{ $value }}</span>
                </div>
            @endforeach
        </div>
    </div>

    {{-- Son Sorgu Bilgisi --}}
    <div class="rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="bg-gray-50 dark:bg-gray-800 px-4 py-2 font-semibold text-gray-700 dark:text-gray-200">
            Son Sorgu Bilgisi
        </div>

        @if ($lastLog)
            <div class="divide-y divide-gray-100 dark:divide-gray-700">
                @php
                    $logRows = [
                        ['İşlem Zamanı', $lastLog->created_at->timezone('Europe/Istanbul')->format('d.m.Y H:i:s') . ' (' . $lastLog->created_at->diffForHumans() . ')'],
                        ['İşlem Türü',   match($lastLog->action) {
                                             'activated'   => '✅ Aktivasyon',
                                             'verified'    => '🔍 Doğrulama',
                                             'deactivated' => '🔓 Deaktivasyon',
                                             'failed'      => '❌ Başarısız',
                                             default       => $lastLog->action,
                                         }],
                        ['IP Adresi',    $lastLog->ip_address ?: '—'],
                        ['Domain',       $lastLog->domain ?: '—'],
                        ['User Agent',   $lastLog->user_agent ? \Illuminate\Support\Str::limit($lastLog->user_agent, 80) : '—'],
                        ['Not',          $lastLog->note ?: '—'],
                    ];
                @endphp

                @foreach ($logRows as [$label, $value])
                    <div class="flex px-4 py-2 gap-4">
                        <span class="w-40 shrink-0 text-gray-500 dark:text-gray-400">{{ $label }}</span>
                        <span class="font-medium text-gray-800 dark:text-gray-100 font-mono text-xs break-all">{{ $value }}</span>
                    </div>
                @endforeach
            </div>
        @else
            <div class="px-4 py-6 text-center text-gray-400">
                <x-heroicon-o-clock class="mx-auto mb-2 h-8 w-8" />
                Bu lisans henüz hiç sorgulanmamış.
            </div>
        @endif
    </div>

    {{-- Admin Mesajı --}}
    @if ($license->admin_message)
        <div class="rounded-lg border border-amber-200 dark:border-amber-700 bg-amber-50 dark:bg-amber-900/20 px-4 py-3">
            <div class="flex items-start gap-2">
                <x-heroicon-o-chat-bubble-left-ellipsis class="mt-0.5 h-4 w-4 shrink-0 text-amber-600" />
                <div>
                    <p class="font-semibold text-amber-700 dark:text-amber-400">Aktif Admin Mesajı</p>
                    <p class="mt-1 text-amber-600 dark:text-amber-300">{{ $license->admin_message }}</p>
                </div>
            </div>
        </div>
    @endif

</div>
