<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('licenses', function (Blueprint $table) {
            $table->id();

            // License Identity
            $table->string('license_key', 19)->unique()->comment('Format: XXXX-XXXX-XXXX-XXXX');
            $table->string('secret_token', 64)->comment('HMAC doğrulama için gizli token (SHA-256 hex)');

            // Customer Info
            $table->string('customer_name', 150);
            $table->string('customer_email', 255)->index();

            // Domain & Activation
            $table->string('domain', 255)->nullable()->comment('Kayıtlı domain, ör: example.com');
            $table->unsignedSmallInteger('activation_limit')->default(1)->comment('İzin verilen max aktivasyon sayısı');
            $table->unsignedSmallInteger('current_activations')->default(0)->comment('Mevcut aktif aktivasyon sayısı');

            // Status
            $table->enum('status', ['active', 'suspended', 'expired'])->default('active')->index();
            $table->timestamp('valid_until')->nullable()->comment('NULL ise süresiz');

            // Metadata
            $table->text('admin_message')->nullable()->comment('Admin notları veya kullanıcıya gösterilecek mesaj');
            $table->timestamp('last_verify_at')->nullable()->comment('Son başarılı doğrulama zamanı');

            $table->timestamps();
            $table->softDeletes();

            // Composite indexes for common queries
            $table->index(['license_key', 'status']);
            $table->index(['customer_email', 'status']);
            $table->index(['domain', 'status']);
            $table->index(['status', 'valid_until']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('licenses');
    }
};
