<?php

namespace App\Providers\Filament;

use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\NavigationGroup;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use App\Filament\Resources\LicenseResource;
use App\Filament\Widgets\StatsOverviewWidget;
use App\Filament\Widgets\RecentActivationsWidget;
use App\Filament\Widgets\LicenseChartWidget;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->default()
            ->id('admin')
            ->path('admin')
            ->login()

            // ── Marka ──────────────────────────────────────────────────────────
            ->brandName('LMS Yönetim Paneli')
            ->brandLogo(null)
            ->favicon(null)

            // ── Renk Paleti ────────────────────────────────────────────────────
            ->colors([
                'primary'  => Color::Indigo,
                'danger'   => Color::Rose,
                'warning'  => Color::Amber,
                'success'  => Color::Emerald,
                'info'     => Color::Sky,
                'gray'     => Color::Slate,
            ])

            // ── Dil ────────────────────────────────────────────────────────────
            ->locale('tr')

            // ── Dark Mode ──────────────────────────────────────────────────────
            ->darkMode(true)

            // ── Navigasyon ─────────────────────────────────────────────────────
            ->navigationGroups([
                NavigationGroup::make('Lisans Yönetimi')
                    ->icon('heroicon-o-key'),
                NavigationGroup::make('Sistem')
                    ->icon('heroicon-o-cog-6-tooth')
                    ->collapsed(),
            ])

            // ── Kaynaklar ──────────────────────────────────────────────────────
            ->resources([
                LicenseResource::class,
            ])

            // ── Sayfalar ───────────────────────────────────────────────────────
            ->pages([
                Pages\Dashboard::class,
            ])

            // ── Widget'lar ─────────────────────────────────────────────────────
            ->widgets([
                StatsOverviewWidget::class,
                LicenseChartWidget::class,
                RecentActivationsWidget::class,
            ])

            // ── Middleware ─────────────────────────────────────────────────────
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([
                Authenticate::class,
            ])

            // ── Bildirimler ────────────────────────────────────────────────────
            ->databaseNotifications()
            ->databaseNotificationsPolling('30s')

            // ── Global Arama ────────────────────────────────────────────────────
            ->globalSearch(true)
            ->globalSearchKeyBindings(['command+k', 'ctrl+k'])

            // ── Breadcrumb ─────────────────────────────────────────────────────
            ->breadcrumbs(true)

            // ── Sidebar ────────────────────────────────────────────────────────
            ->sidebarCollapsibleOnDesktop()
            ->maxContentWidth('full');
    }
}
