<?php

namespace App\Providers;

use App\Services\LicenseKeyGenerator;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // LicenseKeyGenerator singleton olarak kaydet
        $this->app->singleton(LicenseKeyGenerator::class, function () {
            return new LicenseKeyGenerator();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
