<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LicenseActivationLog extends Model
{
    public const UPDATED_AT = null; // Sadece created_at kullanılıyor

    protected $fillable = [
        'license_id',
        'action',
        'domain',
        'ip_address',
        'user_agent',
        'note',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    public function license(): BelongsTo
    {
        return $this->belongsTo(License::class);
    }
}
