<?php

namespace App\Filament\Resources\LicenseResource\Pages;

use App\Filament\Resources\LicenseResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditLicense extends EditRecord
{
    protected static string $resource = LicenseResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()->label('Sil'),
            Actions\RestoreAction::make()->label('Geri Al'),
            Actions\ForceDeleteAction::make()->label('Kalıcı Sil'),
        ];
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    /**
     * Formu kayıt verileriyle doldururken is_unlimited durumunu hesapla.
     */
    protected function mutateFormDataBeforeFill(array $data): array
    {
        $data['is_unlimited'] = empty($data['valid_until']);
        return $data;
    }

    /**
     * Kaydetmeden önce is_unlimited formunu temizle.
     */
    protected function mutateFormDataBeforeSave(array $data): array
    {
        if (!empty($data['is_unlimited'])) {
            $data['valid_until'] = null;
        }
        unset($data['is_unlimited']);
        return $data;
    }
}
