<?php

namespace App\Exceptions;

use Illuminate\Auth\AuthenticationException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of exception types with their corresponding custom log levels.
     */
    protected $levels = [];

    /**
     * A list of the exception types that are not reported.
     */
    protected $dontReport = [];

    /**
     * A list of the inputs that are never flashed to the session on validation exceptions.
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });

        // API endpoint'lerinde JSON hata yanıtları döndür
        $this->renderable(function (NotFoundHttpException $e, Request $request) {
            if ($request->is('api/*')) {
                return response()->json([
                    'status'    => 'error',
                    'message'   => 'Kaynak bulunamadı.',
                    'data'      => null,
                    'timestamp' => now()->toIso8601String(),
                ], 404);
            }
        });

        $this->renderable(function (AuthenticationException $e, Request $request) {
            if ($request->is('api/*')) {
                return response()->json([
                    'status'    => 'error',
                    'message'   => 'Kimlik doğrulama başarısız.',
                    'data'      => null,
                    'timestamp' => now()->toIso8601String(),
                ], 401);
            }
        });

        $this->renderable(function (ValidationException $e, Request $request) {
            if ($request->is('api/*')) {
                return response()->json([
                    'status'    => 'error',
                    'message'   => 'Doğrulama hatası.',
                    'errors'    => $e->errors(),
                    'data'      => null,
                    'timestamp' => now()->toIso8601String(),
                ], 422);
            }
        });
    }
}
